-- Lohnarten auf Basis der DATEV-Daten
CREATE TABLE lohnarten (
  loa_id                       serial NOT null PRIMARY KEY, -- ID, Primary Key
  loa_nr                       integer NOT null,            -- Lohnartennummer, entsprechend DATEV
  loa_bez                      varchar(100),                -- Lohnartenbezeichnung, entsprechend DATEV
  loa_entgeltgruppen           varchar(400),                -- Angestelltenverhältnis, Auflistung mehrerer möglich per Enum (kommaseparierte Liste)
  loa_prio                     integer NOT null,            -- Priorität, welche Lohnart "höherwertig" ist bei überlappenden Zeiträumen.
  loa_is_default                boolean DEFAULT false,       -- Rückfall-Lohnart, falls kein Fallback in lohnarten_zeiten gefunden wird.
  loa_uebersteuert_weitere_la  boolean DEFAULT false        -- Wenn wahr, dann gilt die zu Beginn der Schicht ermittelte Lohnart für alle weiteren Stempelungen dieses Buchungstages.
);

CREATE UNIQUE INDEX xtt32616 ON lohnarten (loa_nr, loa_entgeltgruppen); -- Lohnart darf nur einmal pro Entgeltgruppe definiert werden.

CREATE OR REPLACE FUNCTION lohnarten__b_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF EXISTS ( SELECT 1 
                FROM lohnarten 
                WHERE --TSystem.ENUM_GetValue__list__contains_all__values( loa_entgeltgruppen, new.loa_entgeltgruppen ) -- ENUM_GetValue__list__equals__values???
                      loa_entgeltgruppen = ANY( TSystem.ENUM_list_to_array( new.loa_entgeltgruppen ) ) -- > altes TSystem.ENUM_GetValue, siehe https://github.com/prodat/psql/pull/1106 -- DAS IST DEFINITIV FALSCH. Es vergleiche eine LISTE mit einzelnen Element. Das wird NIE treffen, sobald loa_entgeltgruppen mehrere Elemente enthält!
                  AND loa_id  <> new.loa_id -- nicht der eigene Datensatz
                  AND loa_prio = new.loa_prio ) THEN 
        
      RAISE EXCEPTION 'Fehler beim INSERT der Lohnart "%" (LA-NR: %) Es existiert bereits eine Lohnart mit Priorität % für die Entgeltgruppe % - Bitte prüfen.', new.loa_bez, new.loa_nr, new.loa_prio , new.loa_entgeltgruppen ; 
      RETURN null;
    END IF; 
       
    RETURN new;
  END $$ LANGUAGE plpgsql;
  
  CREATE TRIGGER lohnarten__b_iu
    BEFORE INSERT OR UPDATE
    OF loa_entgeltgruppen, loa_prio
    ON lohnarten
    FOR EACH ROW
    EXECUTE PROCEDURE lohnarten__b_iu();
    
--


-- Lohnarten-Zeiten
CREATE TABLE lohnarten_zeiten (
  loaz_id               serial NOT null PRIMARY KEY,                   -- ID, Primary Key
  loaz_laid             integer REFERENCES lohnarten(loa_id) NOT null,  -- ID in Lohnarten, FK
  loaz_starttime        time(0) without time zone NOT null,            -- Startzeit der Lohnart
  loaz_endtime          time(0) without time zone NOT null,            -- Endezeit der Lohnart
  loaz_starttime_spread time(0) without time zone,                     -- alternativ Zeitpunkt, ab wann MA bereits vor Schicht anfangen darf
  loaz_endtime_spread   time(0) without time zone,                     -- alternativ Zeitpunkt, bis wann MA nach Schicht bleiben darf
  loaz_is_monday         boolean DEFAULT false,                         -- Montag
  loaz_is_tuesday        boolean DEFAULT false,                         -- Dienstag
  loaz_is_wednesday      boolean DEFAULT false,                         -- Mittwoch
  loaz_is_thursday       boolean DEFAULT false,                         -- Donnerstag
  loaz_is_friday         boolean DEFAULT false,                         -- Freitag
  loaz_is_saturday       boolean DEFAULT false,                         -- Samstag
  loaz_is_sunday         boolean DEFAULT false,                         -- Sonntag
  loaz_is_holiday        boolean DEFAULT false,                         -- Feiertag
  loaz_is_default        boolean DEFAULT false                          -- Rückfall Lohnarten_zeiten
);

-- Lohnmodelle #17365
-- Es soll ermöglicht werden, dass bestimmte Zuschläge nur in einer Tagesplan-Schicht gewertet werden
-- Verknüpfung ist nur über die Lohnartzeiten sinnvoll, da zB Nachtschicht-Zuschläge mehrere Zeiträume pro Lohnart haben
CREATE TABLE lohnmodelle (
  loam_id            serial NOT null PRIMARY KEY,                    -- ID, Primary Key
  loam_loaz_id       integer REFERENCES lohnarten_zeiten(loaz_id) NOT null,  -- ID in Lohnarten, FK
  loam_tpl_name      VARCHAR(20) -- Tagesplan 
);


-- TODO:
-- UNIQUES - noch unschlüssig wie am besten
